function [Wavelength,S1,S2,S3,S4,S5,S6,S7,S8,S9,S10,S11,S12,S13,S14] = hiscale_importUVVIS(workbookFile,sheetName,startRow,endRow)
%IMPORTFILE Import data from a spreadsheet
%   [Wavelength,S1,S2,S3,S4,S5,S6,S7,S8,S9,S10,S11,S12,S13,S14] =
%   IMPORTFILE(FILE) reads data from the first worksheet in the Microsoft
%   Excel spreadsheet file named FILE and returns the data as column
%   vectors.
%
%   [Wavelength,S1,S2,S3,S4,S5,S6,S7,S8,S9,S10,S11,S12,S13,S14] =
%   IMPORTFILE(FILE,SHEET) reads from the specified worksheet.
%
%   [Wavelength,S1,S2,S3,S4,S5,S6,S7,S8,S9,S10,S11,S12,S13,S14] =
%   IMPORTFILE(FILE,SHEET,STARTROW,ENDROW) reads from the specified
%   worksheet for the specified row interval(s). Specify STARTROW and
%   ENDROW as a pair of scalars or vectors of matching size for
%   dis-contiguous row intervals. To read to the end of the file specify an
%   ENDROW of inf.%
% Example:
%   [Wavelength,S1,S2,S3,S4,S5,S6,S7,S8,S9,S10,S11,S12,S13,S14] = importfile('SOM_UV-VIS_MAC_rdy2import.xlsx','raw data',4,2051);
%
%   See also XLSREAD.

% Auto-generated by MATLAB on 2018/11/30 12:45:55

%% Input handling

% If no sheet is specified, read first sheet
if nargin == 1 || isempty(sheetName)
	sheetName = 1;
end

% If row start and end points are not specified, define defaults
if nargin <= 3
	startRow = 4;
	endRow = 2051;
end

%% Import the data
data = xlsread(workbookFile, sheetName, sprintf('A%d:O%d',startRow(1),endRow(1)));
for block=2:length(startRow)
	tmpDataBlock = xlsread(workbookFile, sheetName, sprintf('A%d:O%d',startRow(block),endRow(block)));
	data = [data;tmpDataBlock]; %#ok<AGROW>
end

%% Allocate imported array to column variable names
Wavelength = data(:,1);
S1 = data(:,2);
S2 = data(:,3);
S3 = data(:,4);
S4 = data(:,5);
S5 = data(:,6);
S6 = data(:,7);
S7 = data(:,8);
S8 = data(:,9);
S9 = data(:,10);
S10 = data(:,11);
S11 = data(:,12);
S12 = data(:,13);
S13 = data(:,14);
S14 = data(:,15);

